#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int N = (int) 1e6;
const int inf = (int) 2e9 + 100;
int d[N], p[N], pe[N], n, m, u, v, w, delta[N], inpath[N], used[N];
vector< pair< int, pair<int, int> > > adj[N];

struct cmp_dist {
	bool operator()(int i, int j) {
		return mp(d[i], i) < mp(d[j], j);
	}
};

int dfs(int v) {
	if (used[v] != -1) return used[v];
	if (inpath[v] != -1) return inpath[v];
	for (int i = 0; i < sz(adj[v]); ++i) {
		int u = adj[v][i].fs, w = adj[v][i].sc.fs;
		if (d[v] != d[u] + w) continue;
		used[v] = max(used[v], dfs(u));
	}
	return used[v];
}

int main() {
	//assert(freopen("input.txt", "r", stdin));
	//assert(freopen("output.txt", "w", stdout));
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; ++i) {
		scanf("%d%d%d", &u, &v, &w), --u, --v;
		adj[u].pb(mp(v, mp(w, i))), adj[v].pb(mp(u, mp(w, i)));
	}
	set<int, cmp_dist> q;
	for (int i = 0; i < n; ++i) {
		d[i] = (i == n - 1) ? 0 : inf;
		p[i] = inpath[i] = used[i] = -1;
		q.insert(i);
	}
	while (!q.empty()) {
		int v = *q.begin();
		q.erase(q.begin());
		if (d[v] == inf) break;
		for (int i = 0; i < sz(adj[v]); ++i) {
			int u = adj[v][i].fs, w = adj[v][i].sc.fs;
			if (d[u] > d[v] + w) {
				q.erase(u);
				d[u] = d[v] + w;
				p[u] = v, pe[u] = adj[v][i].sc.sc;
				q.insert(u);
			}
		}
	}
	int v = 0;
	vector<int> path, epath, ans;
	while (v != -1) {
		path.pb(v);
		epath.pb(pe[v]);
		inpath[v] = sz(path) - 1;
		v = p[v];
	}
	for (int i = 0; i + 1 < sz(path); ++i) {
		int v = path[i], mx = i;
		for (int j = 0; j < sz(adj[v]); ++j) {
			int u = adj[v][j].fs, w = adj[v][j].sc.fs;
			if ((u == path[i + 1]) || (d[v] != d[u] + w)) continue;
			mx = max(mx, dfs(u));
		}
		delta[i]++, delta[mx]--;
	}
	for (int i = 0, sum = 0; i + 1 < sz(path); ++i) {
		sum += delta[i];
		if (sum == 0) ans.pb(epath[i]);
	}
	sort(ans.begin(), ans.end());
	printf("%d\n", sz(ans));
	for (int i = 0; i < sz(ans); ++i)
		printf("%d%c", ans[i] + 1, " \n"[i == sz(ans) - 1]);
	return 0;
}